﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEditor(typeof(HexObject)), CanEditMultipleObjects]
    public class HexObjectEditor : Editor
    {
        private SerializedProperty _uid;
        private SerializedProperty _variants;
        private SerializedProperty _shadowGroup;
        private SerializedProperty _interaction;
        private SerializedProperty _interactionSfx;
        private SerializedProperty _disableSfx;

        private void OnEnable()
        {
            _uid = serializedObject.FindProperty("_uid");
            _variants = serializedObject.FindProperty("_variants");
            _shadowGroup = serializedObject.FindProperty("_shadowGroup");
            _interaction = serializedObject.FindProperty("_interaction");
            _interactionSfx = serializedObject.FindProperty("_interactionSfx");
            _disableSfx = serializedObject.FindProperty("_disableSfx");
            HexUniqueScriptableObjectHelper.CheckUid(_uid);
        }

        public override Texture2D RenderStaticPreview(string assetPath, Object[] subAssets, int width, int height)
        {
            HexObject @object = target as HexObject;
            Texture2D previewTexture = new Texture2D(width, height);
            IconRenderer.Render(@object.AnySprite, previewTexture, Vector2.one * 0.75f);
            return previewTexture;
        }

        public override void OnInspectorGUI()
        {
            PropertyHelper.ScriptProperty(target);
            EditorGUILayout.PropertyField(_uid);
            EditorGUILayout.PropertyField(_variants);
            ShadowGroupHelper.DrawProperty(_shadowGroup);
            if (_interaction.isExpanded = EditorGUILayout.Foldout(_interaction.isExpanded, "Interaction"))
            {
                PropertyHelper.BeginIndent();
                PropertyHelper.ReferenceProperty<BaseInteraction>(_interaction);
                PropertyHelper.ChildrenProperties(_interaction);
                PropertyHelper.EndIndent();
            }
            EditorGUILayout.PropertyField(_interactionSfx);
            EditorGUILayout.PropertyField(_disableSfx);

            if (GUILayout.Button("Edit"))
            {
                HexObjectEditorWindow.Open(serializedObject.targetObject as HexObject);
            }
            serializedObject.ApplyModifiedProperties();
        }
    }
}
