﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEditor(typeof(HexTile)), CanEditMultipleObjects]
    public class HexTileEditor : Editor
    {
        private SerializedProperty _uid;

        private void OnEnable()
        {
            _uid = serializedObject.FindProperty("_uid");
            HexUniqueScriptableObjectHelper.CheckUid(_uid);
        }

        public override Texture2D RenderStaticPreview(string assetPath, Object[] subAssets, int width, int height)
        {
            HexTile tile = target as HexTile;
            Texture2D previewTexture = new Texture2D(width, height);
            IconRenderer.Render(tile.Sprite, previewTexture, Vector2.one * 0.75f);
            return previewTexture;
        }
    }
}
