﻿using UnityEngine;
using UnityEngine.Localization;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Background")]
    public class HexBackground : ScriptableObject
    {
        [System.Serializable]
        public class AnimationData
        {
            [SerializeField] private Sprite[] _sprites;
            [SerializeField] private float _framesPerSecond = 5f;

            public Sprite[] Sprites { get { return _sprites; } }
            public float FramesPerSecond { get { return _framesPerSecond; } }
        }

        [SerializeField] private LocalizedString _name;
        [SerializeField] private AnimationData _animation;

        public LocalizedString Name { get { return _name; } }
        public AnimationData Animation { get { return _animation; } }
    }
}
