﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Hero")]
    public class HexHero : HexUniqueScriptableObject
    {
        [SerializeField] private Sprite _icon;
        [SerializeField] private HexHeroView _strategicMapPrefab;
        [SerializeField] private HexHeroView _tacticalMapPrefab;

        [Header("Properties")]
        [SerializeField] private int _strategicMapStepsPerDay = 5;

        public Sprite AnySprite
        {
            get
            {
                if (_strategicMapPrefab != null && _strategicMapPrefab.TryGetComponent(out SpriteRenderer spriteRenderer))
                {
                    return spriteRenderer.sprite;
                }

                if (_tacticalMapPrefab != null && _tacticalMapPrefab.TryGetComponent(out spriteRenderer))
                {
                    return spriteRenderer.sprite;
                }
                
                return null;
            }
        }

        public HexHeroView GetView(Transform parent, bool isStrategic)
        {
            HexHeroView view = Instantiate(isStrategic ? _strategicMapPrefab : _tacticalMapPrefab);
            view.transform.SetParent(parent, false);
            return view;
        }

        public HexHeroView StrategicMapPrefab { get { return _strategicMapPrefab; } }
        public HexHeroView TacticalMapPrefab { get { return _tacticalMapPrefab; } }
        public int StrategicMapStepsPerDay { get { return _strategicMapStepsPerDay; } }
    }
}
