﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Materials")]
    public class HexMaterials : ScriptableObject
    {
        [SerializeField] private Material _tileMaterial;
        [SerializeField] private Material _tileMaskMaterial;
        [SerializeField] private Material _objectMaterial;
        [SerializeField] private Material _objectReachableMaterial;
        [SerializeField] private Material _objectHoveredMaterial;
        [SerializeField] private Material _objectInvisibleMaterial;
        [SerializeField] private Material _creatureMaterial;

        private static HexMaterials _instance;

        public static HexMaterials Instance
        {
            get
            {
                if (_instance == null)
                {
                    HexMaterials[] materials = Resources.LoadAll<HexMaterials>("");
                    _instance = materials[0];
                }
                return _instance;
            }
        }

        public Material TileMaterial => _tileMaterial;
        public Material TileMaskMaterial => _tileMaskMaterial;
        public Material ObjectMaterial => _objectMaterial;
        public Material ObjectReachableMaterial => _objectReachableMaterial;
        public Material ObjectHoveredMaterial => _objectHoveredMaterial;
        public Material ObjectInvisibleMaterial => _objectInvisibleMaterial;
        public Material CreatureMaterial => _creatureMaterial;
    }
}
