﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Creatures/Ranged Creature")]
    public class HexRangedCreature : HexCreature
    {
        [SerializeField] private AudioPreset _rangedAttackSfx;

        [Space]
        [SerializeField] private int _range = 1;
        [SerializeField] private int _maxRange = 2;
        [SerializeField] private float _rangedDamage = 1.0f;
        [SerializeField] private Sprite _projectile;

        public AudioPreset RangedAttackSfx { get { return _rangedAttackSfx; } }

        public int Range { get { return _range; } }
        public int MaxRange { get { return _maxRange; } }
        public float RangedDamage { get { return _rangedDamage; } }
        public Sprite Projectile { get { return _projectile; } }
    }
}
