﻿using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Road")]
    public class HexRoad : ScriptableObject
    {
        [System.Serializable]
        private class HexRoadInfo
        {
            [SerializeField] private HexDirection _direction;
            [SerializeField] private KeyValue<HexTerrain, Sprite[]>[] _sprites;

            public HexDirection Direction { get { return _direction; } }

            public Sprite[] GetSprites(HexTerrain terrain)
            {
                foreach (KeyValue<HexTerrain, Sprite[]> pair in _sprites)
                {
                    if (pair.Key == terrain)
                    {
                        return pair.Value;
                    }
                }
                return _sprites[0].Value;
            }
        }

        [SerializeField] private byte _type = 1;
        [SerializeField] private HexRoadInfo[] _roadInfos;
        [SerializeField] private byte _strategicMovementCost = 5;
        [SerializeField] private byte _tacticalMovementCost = 5;

        private Dictionary<HexDirection, HexRoadInfo> _directionDict = new();

        public byte Type { get { return _type; } }
        public byte StrategicMovementCost { get { return _strategicMovementCost; } }
        public byte TacticalMovementCost { get { return _tacticalMovementCost; } }

        public Sprite GetSprite(HexDirection direction, int index, HexTerrain terrain = null)
        {
            if (_directionDict.Count == 0)
            {
                foreach (HexRoadInfo roadInfo in _roadInfos)
                {
                    _directionDict.Add(roadInfo.Direction, roadInfo);
                }
            }

            if (_directionDict.TryGetValue(direction, out HexRoadInfo info))
            {
                Sprite[] sprites = info.GetSprites(terrain);
                return sprites[Mathf.Clamp(index, 0, sprites.Length - 1)];
            }

            return null;
        }

        public static HexRoad[] GetAll()
        {
            return Resources.LoadAll<HexRoad>("Terrains/Roads");
        }
    }
}
