﻿using System.Collections.Generic;

namespace PK
{
    public partial class BaseController<TCustomContext>
    {
        protected interface ITurnForCommands
        {
            void SkipTurn();
        }

        protected interface ITurn : ITurnForCommands
        {
            void Push(ICommand command);
        }

        private class Turn : ITurn
        {
            private IContext _context;
            //private ICommandQueue _commandQueue;
            private List<ICommand> _commands = new List<ICommand>();

            public Turn(IContext context)
            {
                _context = context;
            }

            void ITurn.Push(ICommand command)
            {
                _commands.Add(command);
            }

            public bool Execute()
            {
                if (_commands.Count == 0)
                {
                    return false;
                }

                ICommand currentCommand = _commands[0];
                CommandResult commandResult = currentCommand.Execute(_context);
                if (_commands.Count > 0)
                {
                    if (commandResult != CommandResult.Continue)
                    {
                        _commands.RemoveAt(0);

                        if (commandResult == CommandResult.Complete)
                        {
                            //_commandQueue.Push(currentCommand);
                        }
                    }
                    return true;
                }
                else
                {
                    return false;
                }
            }

            void ITurnForCommands.SkipTurn()
            {
                _commands.Clear();
            }
        }
    }
}
