﻿using UnityEngine;

namespace PK
{
    public delegate void OnEntityCreateEvent(IEntityModelForView modelForView);
    public delegate void OnEntityMoveEvent(ulong id, Vector2Int position, Vector2 offset);
    public delegate void OnEntityDestroyEvent(ulong id);
    public delegate void OnEntityChangeEvent(IEntityModelForView modelForView);
    public delegate void OnEntitySetActiveEvent(ulong id, bool active);
    public delegate void OnHexTerrainChangedEvent();

    public delegate void OnBoolVariableChangeEvent(string name, bool newValue);
    public delegate void OnIntVariableChangeEvent(string name, int newValue);

    public interface IMapEvents
    {
        public event OnEntityCreateEvent OnEntityCreate;
        public event OnEntityMoveEvent OnEntityMove;
        public event OnEntityDestroyEvent OnEntityDestroy;
        public event OnEntityChangeEvent OnEntityChange;
        public event OnEntitySetActiveEvent OnEntitySetActive;
        public event OnHexTerrainChangedEvent OnHexTerrainChanged;

        public event OnBoolVariableChangeEvent OnBoolVariableChange;
        public event OnIntVariableChangeEvent OnIntVariableChange;
    }

    public class MapEvents : IMapEvents
    {
        public event OnEntityCreateEvent OnEntityCreate;
        public event OnEntityMoveEvent OnEntityMove;
        public event OnEntityDestroyEvent OnEntityDestroy;
        public event OnEntityChangeEvent OnEntityChange;
        public event OnEntitySetActiveEvent OnEntitySetActive;
        public event OnHexTerrainChangedEvent OnHexTerrainChanged;

        public event OnBoolVariableChangeEvent OnBoolVariableChange;
        public event OnIntVariableChangeEvent OnIntVariableChange;

        public void CallOnEntityCreate(IEntityModelForView modelForView)
        {
            OnEntityCreate?.Invoke(modelForView);
        }

        public void CallOnEntityMove(ulong id, Vector2Int position, Vector2 offset)
        {
            OnEntityMove?.Invoke(id, position, offset);
        }

        public void CallOnEntityDestroy(ulong id)
        {
            OnEntityDestroy?.Invoke(id);
        }

        public void CallOnEntityChange(IEntityModelForView modelForView)
        {
            OnEntityChange?.Invoke(modelForView);
        }

        public void CallOnEntitySetActive(ulong id, bool active)
        {
            OnEntitySetActive?.Invoke(id, active);
        }

        public void CallOnBoolVariableChange(string name, bool newValue)
        {
            OnBoolVariableChange?.Invoke(name, newValue);
        }

        public void CallOnIntVariableChange(string name, int newValue)
        {
            OnIntVariableChange?.Invoke(name, newValue);
        }

        public void CallOnHexTerrainChanged()
        {
            OnHexTerrainChanged?.Invoke();
        }
    }
}
