﻿
namespace PK
{
    public struct HexContent
    {
        public enum ContentType
        {
            Empty,
            Obstacle,
            Hero,
            Creature,
            CreatureSquad,
            Interactable,
            Hidden
        }

        public ContentType Type;
        public ulong Id;
        public Player Player;

        public HexContent(ContentType type)
        {
            Type = type;
            Id = 0;
            Player = Player.Unknown;
        }

        public HexContent(ContentType type, ulong id)
        {
            Type = type;
            Id = id;
            Player = Player.Unknown;
        }

        public HexContent(ContentType type, ulong id, Player player)
        {
            Type = type;
            Id = id;
            Player = player;
        }
    }
}
