﻿using DG.Tweening;
using UnityEngine;

namespace PK
{
    public class FadeView : MonoBehaviour
    {
        private static FadeView _instance;

        public static FadeView Instance { get { return _instance; } }

        [SerializeField] private Canvas _canvas;
        [SerializeField] private SpriteRenderer _sprite;

        private void Awake()
        {
            _instance = this;
        }

        public void FadeOut(float time, float delay = 0f, bool hideUI = true, System.Action callback = null)
        {
            _sprite.gameObject.SetActive(true);
            _sprite.color = Color.clear;
            _sprite.sortingOrder = _canvas.sortingOrder + (hideUI ? 1 : -1);
            _sprite.DOFade(1f, time).SetDelay(delay).OnComplete(() =>
            {
                callback?.Invoke();
            });
        }

        public void FadeIn(float time, float delay = 0f, bool hideUI = true, System.Action callback = null)
        {
            _sprite.gameObject.SetActive(true);
            _sprite.color = Color.black;
            _sprite.sortingOrder = _canvas.sortingOrder + (hideUI ? 1 : -1);
            _sprite.DOFade(0f, time).SetDelay(delay).OnComplete(() =>
            {
                _sprite.gameObject.SetActive(false);
                callback?.Invoke();
            });
        }
    }
}
