﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class ExecuteActionGraphCommand : Command
        {
            private ActionGraph _graph;
            private Player _player;
            private object _executor;
            private object _interactor;
            private IActionContext _context;

            public ExecuteActionGraphCommand(ActionGraph graph, Player player, object executor, object interactor)
            {
                _graph = graph;
                _player = player;
                _executor = executor;
                _interactor = interactor;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                if (_context == null)
                {
                    _context = new ActionContext(_player, context.MapData, context.Savefile, _executor, _interactor, _graph, context.EventManager, context.Locker);
                }

                if (string.IsNullOrEmpty(_graph.CurrentNodeGuid))
                {
                    ActionStartNode startNode = _graph.GetAnyNodeOfType<ActionStartNode>();
                    if (startNode != null)
                    {
                        _graph.CurrentNodeGuid = startNode.Guid;
                        return CommandResult.Continue;
                    }
                    else
                    {
                        return CommandResult.Complete;
                    }
                }

                BaseNode currentNode = _graph.GetNode(_graph.CurrentNodeGuid);

                if (currentNode is ICommandFlowNode)
                {
                    HandleCommandNode(currentNode);
                }

                if (currentNode is IFlowNode flowNode)
                {
                    flowNode.Execute(_context);
                    return CommandResult.Continue;
                }

                if (currentNode is ActionEndNode)
                {
                    _graph.CurrentNodeGuid = null;
                    return CommandResult.Complete;
                }

                UnityEngine.Debug.LogError($"Found the node of wrong type: {currentNode.GetType()}");
                return CommandResult.Complete;
            }

            private void HandleCommandNode(BaseNode node)
            {
                if (node is ActionSwitchTurnNode)
                {
                    PushSubCommand(new TrySwitchDayCommand());
                    PushSubCommand(new SwitchTurnCommand());
                }
            }
        }
    }
}
