﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class StartDaySubCommand : Command
        {
            public StartDaySubCommand()
            {
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                // Start new day
                int newDay = context.CustomContext.Day + 1;
                context.CustomContext.Day = newDay;
                context.EventManager.Get<StrategicEvents>().CallOnStartDay(newDay);

                // Update heroes
                foreach (HexHeroModel hero in context.MapData.Map.GetEnumerable<HexHeroModel>())
                {
                    hero.StepsLeft = HexDatabase.Instance.GetHero(hero.Uid).StrategicMapStepsPerDay;
                    PushSubCommand(new RevealFogOfWarCommand(hero.Position, 5, hero.Player));
                }

                // Generate resources
                HexVariablesModel variables = context.MapData.Map.GlobalVariables;
                foreach (HexObjectModel @object in context.MapData.Map.GetEnumerable<HexObjectModel>())
                {
                    if (@object.Interaction is CapturableBuildingInteraction capturableInteraction)
                    {
                        // TODO per player variables
                        if (capturableInteraction.Player == Player.Red)
                        {
                            foreach (CapturableBuildingInteraction.ResourceGenerationData resourceGeneration in capturableInteraction.ResourcesGeneration)
                            {
                                string name = resourceGeneration.Name;
                                int value = variables.GetInt(name);
                                value += resourceGeneration.Amount;
                                variables.SetInt(name, value);
                                context.EventManager.Get<MapEvents>().CallOnIntVariableChange(name, value);
                            }
                        }
                    }
                }

                // Execute global triggers
                foreach (HexGlobalTriggerModel trigger in context.MapData.Map.GlobalTriggers)
                {
                    if (trigger.Enabled)
                    {
                        // TODO player settings
                        PushSubCommand(new ExecuteActionGraphCommand(trigger.Graph, Player.Red, trigger, null));
                    }
                }
                return CommandResult.Complete;
            }
        }
    }
}
