﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class WalkHeroStartSubCommand : Command
        {
            private ulong _id;

            public WalkHeroStartSubCommand(ulong id)
            {
                _id = id;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                HexHeroModel hero = context.MapData.Map.GetHero(_id);
                hero.StopRequested = false;
                context.EventManager.Get<StrategicEvents>().CallOnHeroStartWalk(_id, hero.Player);
                return CommandResult.Complete;
            }
        }
    }
}
