﻿using UnityEngine;

namespace PK.Strategic
{
    public partial class GameController
    {
        private class WalkHeroSubCommand : Command
        {
            private ulong _id;
            private Vector2Int _start;
            private Vector2Int _end;
            private int _stepCost;

            public WalkHeroSubCommand(ulong id, Vector2Int start, Vector2Int end, int stepCost)
            {
                _id = id;
                _start = start;
                _end = end;
                _stepCost = stepCost;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                HexHeroModel hero = context.MapData.Map.GetHero(_id);
                if (!hero.StopRequested)
                {
                    hero.StepsLeft -= _stepCost;
                    context.MapData.Map.MoveEntity(_end, Vector2.zero, _id);
                    context.EventManager.Get<StrategicEvents>().CallOnHeroWalk(_id, _start, _end);
                    PushSubCommand(new InteractProximityTriggersCommand(_id));
                    PushSubCommand(new RevealFogOfWarCommand(_end, 5, hero.Player));
                }
                return CommandResult.Complete;
            }
        }
    }
}
