﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        public interface IGameContext
        {
            public int Day { get; set; }
            Player Player { get; set; }
            int PlayerCount { get; }
            Player NextPlayer { get; }
        }

        public class GameContext : IGameContext
        {
            private Savefile _savefile;
            private int _playerCount = 1;

            int IGameContext.Day { get { return _savefile.Day; } set { _savefile.Day = value; } }
            Player IGameContext.Player { get { return _savefile.Player; } set { _savefile.Player = value; } }
            int IGameContext.PlayerCount { get { return _playerCount; } }
            Player IGameContext.NextPlayer { get { return (Player)((int)(_savefile.Player + 1) % _playerCount); } }

            public void Init(Savefile savefile, int playerCount)
            {
                _savefile = savefile;
                _playerCount = playerCount;
            }
        }
    }
}
