﻿using UnityEngine;

namespace PK.Strategic
{
    public delegate void OnStartGameEvent();

    public delegate void OnStartDayEvent(int day);
    public delegate void OnEndDayEvent(int day);
    public delegate void OnStartTurnEvent(Player player);
    public delegate void OnEndTurnEvent(Player player);

    public delegate void OnUpdateFogOfWarEvent(bool[] mask, Vector2Int size);

    public delegate void OnHeroStartWalkEvent(ulong id, Player player);
    public delegate void OnHeroWalkEvent(ulong id, Vector2Int start, Vector2Int end);
    public delegate void OnHeroEndWalkEvent(ulong id, Player player);
    public delegate void OnHeroInteractEvent(ulong heroId, ulong id);
    public delegate void OnHeroModifyCreatureSquadsEvent(ulong id);

    public delegate void OnStartBattleEvent(HexMap map, ulong heroId, ulong enemyId, HexCreatureSquadModel[] enemySquads, bool canRetry, Player beginer, System.Action<BattleData> callback);

    public interface IStrategicEvents
    {
        public event OnStartGameEvent OnStartGame;

        public event OnStartDayEvent OnStartDay;
        public event OnStartDayEvent OnEndDay;
        public event OnStartTurnEvent OnStartTurn;
        public event OnEndTurnEvent OnEndTurn;

        public event OnUpdateFogOfWarEvent OnUpdateFogOfWar;
        public event OnRefreshObstacleMaskEvent OnRefreshObstacleMask;

        public event OnHeroStartWalkEvent OnHeroStartWalk;
        public event OnHeroWalkEvent OnHeroWalk;
        public event OnHeroEndWalkEvent OnHeroEndWalk;
        public event OnHeroInteractEvent OnHeroInteract;
        public event OnHeroModifyCreatureSquadsEvent OnHeroModifyCreatureSquads;

        public event OnStartBattleEvent OnStartBattle;
    }

    public class StrategicEvents : IStrategicEvents
    {
        public event OnStartGameEvent OnStartGame;

        public event OnStartDayEvent OnStartDay;
        public event OnStartDayEvent OnEndDay;
        public event OnStartTurnEvent OnStartTurn;
        public event OnEndTurnEvent OnEndTurn;

        public event OnUpdateFogOfWarEvent OnUpdateFogOfWar;
        public event OnRefreshObstacleMaskEvent OnRefreshObstacleMask;

        public event OnHeroStartWalkEvent OnHeroStartWalk;
        public event OnHeroWalkEvent OnHeroWalk;
        public event OnHeroEndWalkEvent OnHeroEndWalk;
        public event OnHeroInteractEvent OnHeroInteract;
        public event OnHeroModifyCreatureSquadsEvent OnHeroModifyCreatureSquads;

        public event OnStartBattleEvent OnStartBattle;

        public void CallOnStartGame()
        {
            OnStartGame?.Invoke();
        }

        public void CallOnStartDay(int day)
        {
            OnStartDay?.Invoke(day);
        }

        public void CallOnEndDay(int day)
        {
            OnEndDay?.Invoke(day);
        }

        public void CallOnStartTurn(Player player)
        {
            OnStartTurn?.Invoke(player);
        }

        public void CallOnEndTurn(Player player)
        {
            OnEndTurn?.Invoke(player);
        }

        public void CallOnUpdateFogOfWar(bool[] mask, Vector2Int size)
        {
            OnUpdateFogOfWar?.Invoke(mask, size);
        }

        public void CallOnRefreshOnstacleMask()
        {
            OnRefreshObstacleMask?.Invoke();
        }

        public void CallOnHeroStartWalk(ulong id, Player player)
        {
            OnHeroStartWalk?.Invoke(id, player);
        }

        public void CallOnHeroWalk(ulong id, Vector2Int start, Vector2Int end)
        {
            OnHeroWalk?.Invoke(id, start, end);
        }

        public void CallOnHeroEndWalk(ulong id, Player player)
        {
            OnHeroEndWalk?.Invoke(id, player);
        }

        public void CallOnHeroInteract(ulong heroId, ulong id)
        {
            OnHeroInteract?.Invoke(heroId, id);
        }

        public void CallOnHeroModifyCreatureSquads(ulong id)
        {
            OnHeroModifyCreatureSquads?.Invoke(id);
        }

        public void CallOnStartBattle(HexMap map, ulong heroId, ulong enemyId, HexCreatureSquadModel[] enemySquads, bool canRetry, Player beginer, System.Action<BattleData> callback)
        {
            OnStartBattle?.Invoke(map, heroId, enemyId, enemySquads, canRetry, beginer, callback);
        }
    }
}
