﻿using System.Collections.Generic;
using System.Linq;

namespace PK.Tactical
{
    public partial class GameController
    {
        private class RangedAttackSquadsCommand : Command
        {
            private ulong _id;
            private ulong _targetId;

            public RangedAttackSquadsCommand(ulong id, ulong targetId)
            {
                _id = id;
                _targetId = targetId;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                List<HexCreatureSquadModel> squads = new();
                List<HexCreatureSquadModel> targetSquads = new();
                HexMapModel map = context.MapData.Map;
                SquadHelper.GetAllSquads(_id, map, squads);
                SquadHelper.GetAllSquads(_targetId, map, targetSquads);
                HexRangedCreature creature = HexDatabase.Instance.GetCreature(squads[0].Uid) as HexRangedCreature;

                float damage = 0f;
                foreach (HexCreatureSquadModel squad in squads)
                {
                    damage += creature.RangedDamage * squad.Units.Count;
                }
                PushSubCommand(new AttackSubCommand(squads, targetSquads));
                damage /= targetSquads.Count;
                if (damage > 0)
                {
                    PushSubCommand(new DamageSquadsCommand(targetSquads, damage));
                }
                context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadsStartAttack(targetSquads.Select((s) => s.Id).ToList());
                return CommandResult.Complete;
            }

            private class AttackSubCommand : Command
            {
                private List<HexCreatureSquadModel> _squads;
                private List<HexCreatureSquadModel> _targetSquads;

                public AttackSubCommand(List<HexCreatureSquadModel> squads, List<HexCreatureSquadModel> targetSquads)
                {
                    _squads = squads;
                    _targetSquads = targetSquads;
                }

                protected override CommandResult ExecuteBeforeChilds(IContext context)
                {
                    context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadsAttackRanged(_squads.Select((s) => s.Id).ToList(), _targetSquads.Select((s) => s.Position).ToList());
                    foreach (HexCreatureSquadModel squad in _squads)
                    {
                        squad.HasAction = false;
                        if (squad.ParentSquadId == 0)
                        {
                            context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadUpdate(squad.Id, false);
                        }
                    }
                    return CommandResult.Complete;
                }
            }
        }
    }
}
