﻿
using System.Linq;

namespace PK.Tactical
{
    public partial class GameController
    {
        private class StartGameCommand : Command
        {
            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                foreach (HexCreatureSquadModel squad in context.MapData.Map.GetEnumerable<HexCreatureSquadModel>())
                {
                    HexCreature creature = HexDatabase.Instance.GetCreature(squad.Uid);
                    PushSubCommand(new RevealFogOfWarCommand(squad.Position, creature.VisionRange, squad.Player));
                }
                // TODO refactor
                context.EventManager.Get<TacticalEvents>().CallOnStartGame(context.MapData.Map.GetEnumerable<HexSpawnAreaModel>().First((a) => a.Player == Player.Red).Position);
                return CommandResult.Complete;
            }
        }
    }
}
