﻿
namespace PK.Tactical
{
    public partial class GameController
    {
        private class TryToEndTurnCommand : Command
        {
            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                foreach (HexCreatureSquadModel squad in context.MapData.Map.GetEnumerable<HexCreatureSquadModel>())
                {
                    if (squad.Player == context.CustomContext.Player && squad.HasAction)
                    {
                        return CommandResult.Complete;
                    }
                }
                PushSubCommand(new SwitchTurnCommand());
                return CommandResult.Complete;
            }
        }
    }
}
