﻿using UnityEngine;

namespace PK
{
    public static class ClickCooldown
    {
        private const float TIME_DELTA = 1.0f / 6.0f;

        private static float _lastClickTime;

        public static bool TryClick(float multiplier = 1f)
        {
            if (Time.realtimeSinceStartup - _lastClickTime > TIME_DELTA * multiplier)
            {
                _lastClickTime = Time.realtimeSinceStartup;
                return true;
            }
            return false;
        }

        public static void Reset()
        {
            _lastClickTime = Time.realtimeSinceStartup;
        }
    }
}
