﻿using UnityEngine;

namespace PK
{
    public class ActionBinaryNode : BaseNode, IConditionNode
    {
        private enum OperationType
        {
            And,
            Or
        }

        [SerializeField] private string _inPortAGuid;
        [SerializeField] private string _inPortBGuid;
        [SerializeField] private string _outPortGuid;
        [SerializeField] private OperationType _operation;

        public string InPortAGuid { get { return _inPortAGuid; } set { _inPortAGuid = value; } }
        public string InPortBGuid { get { return _inPortBGuid; } set { _inPortBGuid = value; } }
        public string OutPortGuid { get { return _outPortGuid; } set { _outPortGuid = value; } }

        bool IConditionNode.Evaluate(IActionContext context)
        {
            bool valueA = context.Graph.GetConnectedNode(_inPortAGuid) is IConditionNode conditionA && conditionA.Evaluate(context);
            bool valueB = context.Graph.GetConnectedNode(_inPortBGuid) is IConditionNode conditionB && conditionB.Evaluate(context);

            switch (_operation)
            {
                case OperationType.And:
                    return valueA && valueB;
                case OperationType.Or:
                    return valueA || valueB;
                default:
                    return false;
            }
        }
    }
}
