﻿using UnityEngine;
using UnityEngine.Localization;

namespace PK
{
    public interface IDialogMessageForView
    {
        LocalizedString Message { get; }
        HexCharacter Character { get; }
        HexBackground Background { get; }

        void Skip();
    }

    public class ActionDialogMessageNode : ActionDefaultNode, IFlowNode, IDialogMessageForView
    {
        private static string LOCK = "ActionDialogMessageNodeLock";

        [SerializeField] private LocalizedString _line;
        [SerializeField] private HexCharacter _character;
        [SerializeField] private HexBackground _background;

        LocalizedString IDialogMessageForView.Message => _line;
        HexCharacter IDialogMessageForView.Character => _character;
        HexBackground IDialogMessageForView.Background => _background;

        private IActionContext _context;

        void IFlowNode.Execute(IActionContext context)
        {
            _context = context;
            context.Locker.Lock(LOCK);
            context.EventManager.Get<InteractionEvents>().CallOnMessage(this, context.Player);
        }

        void IDialogMessageForView.Skip()
        {
            _context.Locker.Unlock(LOCK);
            _context.Graph.MoveToNextNode(_outPortGuid);
        }
    }
}
