﻿using UnityEngine;

namespace PK
{
    public class ActionModifyEntityEnabledNode : ActionDefaultNode, IFlowNode
    {
        [SerializeField] private bool _isSelf;
        [SerializeField] private ulong _entityId;
        [SerializeField] private bool _value;

        void IFlowNode.Execute(IActionContext context)
        {
            HexEntityModel entity;
            if (_isSelf && context.Executor is HexGlobalTriggerModel trigger)
            {
                trigger.Enabled = _value;
            }
            else
            {
                if (_isSelf)
                {
                    entity = context.Executor as HexEntityModel;
                }
                else
                {
                    entity = context.Map.GetEntity(_entityId);
                }
                if (entity != null)
                {
                    entity.Enabled = _value;
                    context.EventManager.Get<MapEvents>().CallOnEntitySetActive(entity.Id, _value);
                    context.Map.RefreshInteractionMask();
                    context.MapData.RefreshObstacleMask();
                    context.EventManager.Get<MapDataEvents>().CallOnRefreshObstacleMask();
                }
                else
                {
                    Debug.LogError("Entity is null.");
                }
            }
            context.Graph.MoveToNextNode(_outPortGuid);
        }
    }
}
