using UnityEngine;

namespace PK
{
    public class ActionSetWeatherNode : ActionDefaultNode, IFlowNode
    {
        [SerializeField] public HexWeather weather;
        [SerializeField] public HexWeather.Severity severity = HexWeather.Severity.None;

        public void Execute(IActionContext context)
        {
            if (WeatherSystem.Instance != null)
            {
                WeatherSystem.Instance.SetWeather(weather, severity);
                Debug.Log($"[ActionSetWeatherNode] Weather set to {(weather != null ? weather.weatherName : "None")} with severity {severity}");
            }
            else
            {
                Debug.LogWarning("[ActionSetWeatherNode] WeatherSystem instance not found.");
            }

            context.Graph.MoveToNextNode(_outPortGuid);
        }
    }
}
