using System.Linq;
using UnityEngine;

namespace PK
{
    public class ActionStartBattleNode : BaseNode, IFlowNode
    {
        private static string LOCK = "ActionStartBattleNodeLock";

        [SerializeField] private string _inPortGuid;
        [SerializeField] private string _outPortAGuid;
        [SerializeField] private string _outPortBGuid;

        [SerializeField] private HexMap _map;
        [SerializeField] private StartBattleInteraction.EnemyData[] _enemies;
        [SerializeField] private bool _canRetry = true;
        [SerializeField] private bool _enemyStarts = false;
        [SerializeField] private bool _specificHero = false;
        [SerializeField] private ulong _heroEntityId;

        void IFlowNode.Execute(IActionContext context)
        {
            HexMap map = _map;
            HexHeroModel hero = context.Interactor as HexHeroModel;
            if (_specificHero)
            {
                hero = context.Map.GetEntity(_heroEntityId) as HexHeroModel;
            }

            if (hero == null)
            {
                Debug.LogError("No interactor or hero specified for ActionStartBattleNode");
            }
            if (map == null)
            {
                Debug.LogError("No map specified for ActionStartBattleNode");
            }
            if (map.IsStrategic)
            {
                Debug.LogError("Strategic map specified for ActionStartBattleNode");
            }
            context.Locker.Lock(LOCK);
            context.EventManager.Get<Strategic.StrategicEvents>().CallOnStartBattle(map, hero.Id, 0, _enemies.Select((e) => new HexCreatureSquadModel(e.Creature.Uid, 0, Vector2Int.zero, hero.Player, Mathf.Min(e.Count, e.Creature.SoldiersPerUnit), e.Creature.Health)).ToArray(), _canRetry, _enemyStarts ? Player.Blue : Player.Red, (BattleData result) =>
            {
                context.Locker.Unlock(LOCK);
                if (result.Winner == hero.Player)
                {
                    context.Graph.MoveToNextNode(_outPortAGuid);
                }
                else
                {
                    context.Graph.MoveToNextNode(_outPortBGuid);
                }
            });
        }
    }
}
