using UnityEditor;
using UnityEngine;

namespace PK
{

    public class ActionGraphEditorWindow : EditorWindow
    {
        [SerializeField] private Object _parentObject;
        [SerializeField] private string _propertyPath;

        private BaseGraphView _graphView;

        public static void Open(Object parentObject, string propertyPath)
        {
            ActionGraphEditorWindow window = (ActionGraphEditorWindow)GetWindow(typeof(ActionGraphEditorWindow), false, "Action Tree Editor");
            if (window._parentObject != null)
            {
                window.SaveChanges();
            }
            window.wantsLessLayoutEvents = true;
            window._parentObject = parentObject;
            window._propertyPath = propertyPath;
            window.Initialize();
            window.Show();
        }

        private void Initialize()
        {
            if (_parentObject == null || string.IsNullOrEmpty(_propertyPath))
            {
                return;
            }

            _graphView = new ActionGraphView(_parentObject, _propertyPath, this);
            _graphView.SetupZoom(0.1f, 1f);
            _graphView.style.flexGrow = 1;
            _graphView.OnChanged += OnChanged;

            rootVisualElement.Clear();
            rootVisualElement.Add(_graphView);
        }

        private void OnEnable()
        {
            Initialize();
        }

        private void OnFocus()
        {
            MapDataHelper.Clear();
        }

        private void OnDestroy()
        {
            if (_graphView != null)
            {
                _graphView.Dispose();
                _graphView.OnChanged -= OnChanged;
            }
        }

        private void OnChanged()
        {
            hasUnsavedChanges = true;
        }

        public override void SaveChanges()
        {
            base.SaveChanges();
            SerializedObject serializedObject = new SerializedObject(_parentObject);
            SerializedProperty graphProperty = serializedObject.FindProperty(_propertyPath);
            graphProperty.boxedValue = _graphView.Graph;

            // Remove invalid nodes
            SerializedProperty nodesProperty = graphProperty.FindPropertyRelative("_nodes");
            for (int i = nodesProperty.arraySize - 1; i >= 0; i--)
            {
                if (nodesProperty.GetArrayElementAtIndex(i).managedReferenceValue == null)
                {
                    nodesProperty.DeleteArrayElementAtIndex(i);
                }
            }
            serializedObject.ApplyModifiedProperties();
            serializedObject.Dispose();
        }
    }
}