﻿using UnityEditor;
using UnityEditor.Experimental.GraphView;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionBinaryNode), "Binary")]
    public class ActionBinaryEditorNode : BaseGraphEditorNode
    {
        public ActionBinaryEditorNode(SerializedProperty property) : base(property)
        {
            title = "Binary";
            SetTitleColor(ActionDefaultEditorNode.Styles.CheckGameStateTitleColor);

            Port inPortA = InstantiatePort(Orientation.Horizontal, Direction.Input, Port.Capacity.Single, "In A", typeof(ConditionPort));
            inputContainer.Add(inPortA);

            SerializedProperty inPortAGuidProperty = property.FindPropertyRelative("_inPortAGuid");
            SerializedProperty inPortBGuidProperty = property.FindPropertyRelative("_inPortBGuid");
            SerializedProperty outPortGuidProperty = property.FindPropertyRelative("_outPortGuid");

            if (string.IsNullOrEmpty(inPortAGuidProperty.stringValue))
            {
                inPortAGuidProperty.stringValue = inPortA.viewDataKey;
            }
            else
            {
                inPortA.viewDataKey = inPortAGuidProperty.stringValue;
            }
            AddPort(inPortA);

            Port inPortB = InstantiatePort(Orientation.Horizontal, Direction.Input, Port.Capacity.Single, "In B", typeof(ConditionPort));
            inputContainer.Add(inPortB);

            if (string.IsNullOrEmpty(inPortBGuidProperty.stringValue))
            {
                inPortBGuidProperty.stringValue = inPortB.viewDataKey;
            }
            else
            {
                inPortB.viewDataKey = inPortBGuidProperty.stringValue;
            }
            AddPort(inPortB);

            Port outPort = InstantiatePort(Orientation.Horizontal, Direction.Output, Port.Capacity.Single, "Out", typeof(ConditionPort));
            outputContainer.Add(outPort);

            if (string.IsNullOrEmpty(outPortGuidProperty.stringValue))
            {
                outPortGuidProperty.stringValue = outPort.viewDataKey;
            }
            else
            {
                outPort.viewDataKey = outPortGuidProperty.stringValue;
            }
            AddPort(outPort);

            _property.serializedObject.ApplyModifiedProperties();

            SerializedProperty operationProperty = property.FindPropertyRelative("_operation");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(operationProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
