﻿using UnityEditor;
using UnityEditor.Experimental.GraphView;

namespace PK
{
    [EditorNode(typeof(ActionBranchNode), "Branch")]
    public class ActionBranchEditorNode : BaseGraphEditorNode
    {
        public ActionBranchEditorNode(SerializedProperty property) : base(property)
        {
            if (Node is ActionBranchNode branchNode)
            {
                title = "Branch";

                SerializedProperty inPortGuidProperty = property.FindPropertyRelative("_inPortGuid");
                SerializedProperty conditionPortGuidProperty = property.FindPropertyRelative("_conditionPortGuid");
                SerializedProperty outPortAGuidProperty = property.FindPropertyRelative("_outPortAGuid");
                SerializedProperty outPortBGuidProperty = property.FindPropertyRelative("_outPortBGuid");

                Port inPort = InstantiatePort(Orientation.Horizontal, Direction.Input, Port.Capacity.Multi, "In", typeof(FlowPort));
                inputContainer.Add(inPort);

                if (string.IsNullOrEmpty(inPortGuidProperty.stringValue))
                {
                    inPortGuidProperty.stringValue = inPort.viewDataKey;
                }
                else
                {
                    inPort.viewDataKey = inPortGuidProperty.stringValue;
                }
                AddPort(inPort);

                Port conditionPort = InstantiatePort(Orientation.Horizontal, Direction.Input, Port.Capacity.Single, "Condition", typeof(ConditionPort));
                inputContainer.Add(conditionPort);

                if (string.IsNullOrEmpty(conditionPortGuidProperty.stringValue))
                {
                    conditionPortGuidProperty.stringValue = conditionPort.viewDataKey;
                }
                else
                {
                    conditionPort.viewDataKey = conditionPortGuidProperty.stringValue;
                }
                AddPort(conditionPort);

                Port outAPort = InstantiatePort(Orientation.Horizontal, Direction.Output, Port.Capacity.Single, "Out Yes", typeof(FlowPort));
                outputContainer.Add(outAPort);

                if (string.IsNullOrEmpty(outPortAGuidProperty.stringValue))
                {
                    outPortAGuidProperty.stringValue = outAPort.viewDataKey;
                }
                else
                {
                    outAPort.viewDataKey = outPortAGuidProperty.stringValue;
                }
                AddPort(outAPort);

                Port outBPort = InstantiatePort(Orientation.Horizontal, Direction.Output, Port.Capacity.Single, "Out No", typeof(FlowPort));
                outputContainer.Add(outBPort);

                if (string.IsNullOrEmpty(outPortBGuidProperty.stringValue))
                {
                    outPortBGuidProperty.stringValue = outBPort.viewDataKey;
                }
                else
                {
                    outBPort.viewDataKey = outPortBGuidProperty.stringValue;
                }
                AddPort(outBPort);

                _property.serializedObject.ApplyModifiedProperties();

                Refresh();
            }
        }
    }
}
