﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionCheckEntityEnabledNode), "Entities/Check Enabled")]
    public class ActionCheckEntityEnabledEditorNode : ActionDefaultEditorNode
    {
        public ActionCheckEntityEnabledEditorNode(SerializedProperty property) : base(property)
        {
            title = "Check Entity Enabled";
            SetTitleColor(Styles.CheckGameStateTitleColor);
            InitializeDefaultPorts(false, true, null, typeof(ConditionPort));

            SerializedProperty isSelfProperty = property.FindPropertyRelative("_isSelf");
            SerializedProperty entityIdProperty = property.FindPropertyRelative("_entityId");
            SerializedProperty valueProperty = property.FindPropertyRelative("_value");

            EntityButton entityButton = new EntityButton(this, entityIdProperty);
            entityButton.Update(!isSelfProperty.boolValue);
            extensionContainer.Add(entityButton);

            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(isSelfProperty);
                PropertyHelper.PropertyField(valueProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    entityButton.Update(!isSelfProperty.boolValue);
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
