﻿using UnityEditor;
using UnityEditor.Rendering;
using UnityEngine.UIElements;
using static PK.HexVariablesModel;

namespace PK
{
    [EditorNode(typeof(ActionCheckVariableNode), "Variables/Check")]
    public class ActionCheckVariableEditorNode : ActionDefaultEditorNode
    {
        public ActionCheckVariableEditorNode(SerializedProperty property) : base(property)
        {
            title = "Check Variable";
            SetTitleColor(Styles.CheckGameStateTitleColor);
            InitializeDefaultPorts(false, true, null, typeof(ConditionPort));

            SerializedProperty idProperty = property.FindPropertyRelative("_id");
            SerializedProperty typeProperty = property.FindPropertyRelative("_type");
            SerializedProperty comparisonProperty = property.FindPropertyRelative("_comparison");
            SerializedProperty boolValueProperty = property.FindPropertyRelative("_boolValue");
            SerializedProperty intValueProperty = property.FindPropertyRelative("_intValue");

            VariableButton variableButton = new VariableButton(this, idProperty);
            extensionContainer.Add(variableButton);

            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                Variable variable = MapDataHelper.GetVariable(idProperty.ulongValue);
                if (variable != null)
                {
                    PropertyHelper.PropertyField(comparisonProperty);
                    if (variable.Type == VariableType.Bool)
                    {
                        typeProperty.SetEnumValue(VariableType.Bool);
                        PropertyHelper.PropertyField(boolValueProperty);
                    }
                    else
                    {
                        typeProperty.SetEnumValue(VariableType.Int);
                        PropertyHelper.PropertyField(intValueProperty);
                    }
                }
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
