﻿using UnityEditor;
using UnityEditor.Experimental.GraphView;
using UnityEngine;

namespace PK
{
    public class ActionDefaultEditorNode : BaseGraphEditorNode
    {
        public static class Styles
        {
            public static Color StartEndTitleColor => new Color(1.0f, 0.6f, 0.0f);
            public static Color MessageTitleColor => new Color(0.0f, 0.5f, 0.5f);
            public static Color ChoicesTitleColor => new Color(0.0f, 0.0f, 0.75f);
            public static Color ChangeGameStateTitleColor => new Color(0.75f, 0.0f, 0.0f);
            public static Color CheckGameStateTitleColor => new Color(0.0f, 0.75f, 0.0f);
        }

        public ActionDefaultEditorNode(SerializedProperty property) : base(property)
        {
        }

        protected void InitializeDefaultPorts(bool input, bool output, System.Type inputType = null, System.Type outputType = null)
        {
            if (input)
            {
                if (inputType == null)
                {
                    inputType = typeof(FlowPort);
                }

                SerializedProperty inPortGuidProperty = _property.FindPropertyRelative("_inPortGuid");

                Port inPort = InstantiatePort(Orientation.Horizontal, Direction.Input, Port.Capacity.Multi, "In", inputType);
                inputContainer.Add(inPort);

                if (string.IsNullOrEmpty(inPortGuidProperty.stringValue))
                {
                    inPortGuidProperty.stringValue = inPort.viewDataKey;
                }
                else
                {
                    inPort.viewDataKey = inPortGuidProperty.stringValue;
                }
                AddPort(inPort);
            }

            if (output)
            {
                if (outputType == null)
                {
                    outputType = typeof(FlowPort);
                }

                SerializedProperty outPortGuidProperty = _property.FindPropertyRelative("_outPortGuid");

                Port outPort = InstantiatePort(Orientation.Horizontal, Direction.Output, Port.Capacity.Single, "Out", outputType);
                outputContainer.Add(outPort);

                if (string.IsNullOrEmpty(outPortGuidProperty.stringValue))
                {
                    outPortGuidProperty.stringValue = outPort.viewDataKey;
                }
                else
                {
                    outPort.viewDataKey = outPortGuidProperty.stringValue;
                }
                AddPort(outPort);
            }
            _property.serializedObject.ApplyModifiedProperties();
        }
    }
}
