﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionFadeScreenNode), "Fade Screen")]
    public class ActionFadeScreenEditorNode : ActionDefaultEditorNode
    {
        public ActionFadeScreenEditorNode(SerializedProperty property) : base(property)
        {
            title = "Fade Screen";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty modeProperty = property.FindPropertyRelative("_mode");
            SerializedProperty hideUIProperty = property.FindPropertyRelative("_hideUI");
            SerializedProperty timeProperty = property.FindPropertyRelative("_time");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(modeProperty);
                PropertyHelper.PropertyField(hideUIProperty);
                PropertyHelper.PropertyField(timeProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
