﻿using UnityEditor;
using UnityEngine;
using UnityEditor.UIElements;
using UnityEngine.UIElements;
using System.Linq;

namespace PK
{
    [EditorNode(typeof(ActionOverrideTerrainNode), "Terrain/Override Terrain")]
    public class ActionOverrideTerrainEditorNode : ActionDefaultEditorNode
    {

        public ActionOverrideTerrainEditorNode(SerializedProperty property) : base(property)
        {
            title = "Terrain Overrides";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty entityIdProperty = property.FindPropertyRelative("_entityId");

            Label label = new Label("Choose map zone");
            extensionContainer.Add(label);
            EntityButton entityButton = new EntityButton(this, entityIdProperty);
            extensionContainer.Add(entityButton);

            SerializedProperty revertOverrideProperty = property.FindPropertyRelative("_revertOverride");
            IMGUIContainer revertOverrideField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                EditorGUILayout.PropertyField(revertOverrideProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                    Refresh();
                }
            });
            extensionContainer.Add(revertOverrideField);

            var terrainToTerrainProperty = property.FindPropertyRelative("_terrainToTerrain");
            IMGUIContainer terrainToTerrainField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                EditorGUILayout.PropertyField(terrainToTerrainProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(terrainToTerrainField);

            Refresh();
        }
    }
}
