﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomPropertyDrawer(typeof(HexVariablesModel.Variable))]
    public class VariablePropertyDrawer : PropertyDrawer
    {
        public override void OnGUI(Rect position, SerializedProperty property, GUIContent label)
        {
            bool foldout = property.isExpanded;
            SerializedProperty nameProperty = property.FindPropertyRelative("_name");
            position.height = EditorGUIUtility.singleLineHeight;
            foldout = EditorGUI.Foldout(position, foldout, new GUIContent(nameProperty.stringValue));
            property.isExpanded = foldout;
            if (foldout)
            {
                position.y += position.height + EditorGUIUtility.standardVerticalSpacing;
                ++EditorGUI.indentLevel;

                SerializedProperty idProperty = property.FindPropertyRelative("_id");
                EditorGUI.BeginDisabledGroup(true);
                EditorGUI.PropertyField(EditorGUI.IndentedRect(position), idProperty);
                EditorGUI.EndDisabledGroup();
                position.y += position.height + EditorGUIUtility.standardVerticalSpacing;

                EditorGUI.PropertyField(EditorGUI.IndentedRect(position), nameProperty);
                position.y += position.height + EditorGUIUtility.standardVerticalSpacing;

                SerializedProperty typeProperty = property.FindPropertyRelative("_type");
                EditorGUI.PropertyField(EditorGUI.IndentedRect(position), typeProperty);
                position.y += position.height + EditorGUIUtility.standardVerticalSpacing;

                SerializedProperty valueProperty = null;
                VariableType type = (VariableType)typeProperty.intValue;
                switch (type)
                {
                    case VariableType.Bool:
                        valueProperty = property.FindPropertyRelative("_boolValue");
                        break;
                    case VariableType.Int:
                        valueProperty = property.FindPropertyRelative("_intValue");
                        break;
                }
                EditorGUI.PropertyField(EditorGUI.IndentedRect(position), valueProperty);
                --EditorGUI.indentLevel;
            }
        }

        public override float GetPropertyHeight(SerializedProperty property, GUIContent label)
        {
            return EditorGUI.GetPropertyHeight(property, true) - (property.isExpanded ? EditorGUIUtility.singleLineHeight : 0);
        }
    }
}
