﻿using UnityEngine;

namespace PK
{
    public interface IHeroModelForView : IEntityModelForView
    {
        public Player Player { get; }
        public int StepsLeft { get; }
        public bool StopRequested { get; set; }
    }

    [System.Serializable]
    public class HexHeroModel : HexEntityModel, IHeroModelForView
    {
        [System.Serializable]
        public class CreatureData
        {
            [SerializeField] private HexCreature _creature;
            [SerializeField] private int _count;

            public HexCreature Creature { get { return _creature; } }
            public int Count { get { return _count; } }
        }

        [SerializeField] private Player _player;
        [SerializeField] private HexCharacter _character;
        [SerializeField, HideInInspector] private int _stepsLeft;
        [SerializeField] private CreatureData[] _startingCreatures;

        private bool _stopRequested = false;

        public Player Player { get { return _player; } set { _player = value; } }
        public HexCharacter Character { get { return _character; } }
        public int StepsLeft { get { return _stepsLeft; } set { _stepsLeft = value; } }
        public CreatureData[] StartingCreatures { get { return _startingCreatures; } }
        public bool StopRequested { get { return _stopRequested; } set { _stopRequested = value; } }
        public override EntityType Type { get { return EntityType.Hero; } }

        public HexHeroModel()
        {
        }

        public HexHeroModel(ulong uid, ulong id, Vector2Int position)
        {
            _uid = uid;
            _id = id;
            _position = position;
        }
    }
}
