﻿using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    [UnityEngine.Scripting.APIUpdating.MovedFrom(false, null, null, "HexMapZoneModel")]
    public class HexMapZoneModel : HexEntityModel
    {
        [SerializeField, HideInInspector] private List<Vector2Int> _points = new(); // axial

        public override EntityType Type { get { return EntityType.MapZone; } }
        public List<Vector2Int> Points { get { return _points; } }

        public HexMapZoneModel()
        {
        }

        public HexMapZoneModel(ulong id, Vector2Int position)
        {
            _id = id;
            _position = position;
        }

        public Vector2Int GetPosition(int index)
        {
            return HexHelper.AxialToOdd(HexHelper.OddToAxial(_position) + _points[index]);
        }
    }
}
