﻿using UnityEngine;

namespace PK
{
    public interface IObjectModelForView : IEntityModelForView
    {
        public Vector2 Offset { get; }
    }

    // These will be created in runtime from HexObject so the map will contain only uids to avoid storing object data
    [UnityEngine.Scripting.APIUpdating.MovedFrom(false, null, null, "HexPropModel")]
    public class HexObjectModel : HexInteractableEntityModel, IObjectModelForView
    {
        [SerializeField, HideInInspector] private Vector2 _offset;

        public Vector2 Offset { get { return _offset; } set { _offset = value; } }
        public override EntityType Type { get { return EntityType.Object; } }

        public HexObjectModel()
        {
        }

        public HexObjectModel(ulong uid, ulong id, Vector2Int position, Vector2 offset)
        {
            _uid = uid;
            _id = id;
            _position = position;
            _offset = offset;
        }
    }
}
