﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace PK
{
    [System.Serializable]
    public class BaseGraph
    {
        [SerializeReference] private List<BaseNode> _nodes = new();
        [SerializeField] private List<NodeConnection> _connections = new();

        public List<BaseNode> Nodes { get { return _nodes; } }
        public List<NodeConnection> Connections { get { return _connections; } }

        public BaseNode GetNode(string guid)
        {
            return _nodes.FirstOrDefault((n) => n.Guid == guid);
        }

        public bool IsConnected(string portGuid)
        {
            return !string.IsNullOrEmpty(GetConnectedNodeGuid(portGuid));
        }

        public BaseNode GetConnectedNode(string portGuid)
        {
            string guid = GetConnectedNodeGuid(portGuid);
            if (guid != null)
            {
                return GetNode(guid);
            }
            return null;
        }

        public string GetConnectedNodeGuid(string portGuid)
        {
            foreach (NodeConnection connection in _connections)
            {
                if (connection.InputPort.PortGuid == portGuid)
                {
                    return connection.OutputPort.NodeGuid;
                }
                if (connection.OutputPort.PortGuid == portGuid)
                {
                    return connection.InputPort.NodeGuid;
                }
            }
            return null;
        }

        public HashSet<BaseNode> GetChildren(BaseNode node)
        {
            HashSet<BaseNode> result = new();

            string guid = node.Guid;
            foreach (NodeConnection connection in _connections)
            {
                if (connection.InputPort.NodeGuid == guid)
                {
                    result.Add(GetNode(connection.OutputPort.NodeGuid));
                    continue;
                }
                if (connection.OutputPort.NodeGuid == guid)
                {
                    result.Add(GetNode(connection.InputPort.NodeGuid));
                    continue;
                }
            }

            return result;
        }

        public T GetAnyNodeOfType<T>()
        {
            return _nodes.OfType<T>().FirstOrDefault();
        }
    }
}
