using System.Collections.Generic;
using UnityEditor;
using UnityEditor.Experimental.GraphView;
using UnityEditor.UIElements;
using UnityEngine;
using UnityEngine.UIElements;

namespace PK
{
    public class BaseGraphEditorNode : Node
    {
        private object _node;
        protected SerializedProperty _property;
        private SerializedProperty _positionProperty;

        private Dictionary<string, Port> _ports = new();

        public object Node { get { return _node; } }
        public Dictionary<string, Port> Ports { get { return _ports; } }
        public BaseGraphView View { get; set; }

        public BaseGraphEditorNode(SerializedProperty property)
        {
            _node = property.managedReferenceValue;
            _property = property;
            _positionProperty = property.FindPropertyRelative("_position");
            AddToClassList("base-graph-node");
            this.Bind(property.serializedObject);
        }

        public void UpdatePosition()
        {
            _positionProperty.rectValue = GetPosition();
            _property.serializedObject.ApplyModifiedProperties();
        }

        protected void Refresh()
        {
            RefreshExpandedState();
            RefreshPorts();
        }

        protected Port InstantiatePort(Orientation orientation, Direction direction, Port.Capacity capacity, string name, System.Type type)
        {
            Port port = InstantiatePort(orientation, direction, capacity, type);
            port.portName = name;
            return port;
        }

        protected void AddPort(Port port)
        {
            _ports[port.viewDataKey] = port;
        }

        protected void SetTitleColor(Color color)
        {
            this.Q("title").style.backgroundColor = color;
            this.Q("title-label").style.color = Color.black;
        }

        public void Validate()
        {
            bool valid = true;
            foreach (KeyValuePair<string, Port> pair in _ports)
            {
                Port port = pair.Value;
                if (port.direction == Direction.Output && !port.connected)
                {
                    valid = false;
                    break;
                }
            }

            VisualElement border = this.Q("node-border");
            StyleColor color = valid ? StyleKeyword.Null : Color.red;
            border.style.borderBottomColor = color;
            border.style.borderLeftColor = color;
            border.style.borderRightColor = color;
            border.style.borderTopColor = color;
        }
    }
}