﻿using System.Linq;
using UnityEditor;
using UnityEngine;

namespace PK
{
    public static class PropertyHelper
    {
        public static void ScriptProperty(Object target)
        {
            using (new EditorGUI.DisabledScope(true))
            {
                if (target is MonoBehaviour)
                {
                    EditorGUILayout.ObjectField("Script", MonoScript.FromMonoBehaviour((MonoBehaviour)target), target.GetType(), false);
                }
                else
                {
                    EditorGUILayout.ObjectField("Script", MonoScript.FromScriptableObject((ScriptableObject)target), target.GetType(), false);
                }
            }
        }

        public static void ReferenceProperty<T>(SerializedProperty property) where T : class
        {
            System.Type type = typeof(T);
            TypeCache.TypeCollection childrenTypes = TypeCache.GetTypesDerivedFrom(type);
            object currentObject = property.managedReferenceValue;
            int index = 0;
            if (currentObject != null)
            {
                System.Type currentType = currentObject.GetType();
                for (int i = 0; i < childrenTypes.Count; i++)
                {
                    if (childrenTypes[i] == currentType)
                    {
                        index = i + 1;
                        break;
                    }
                }
            }

            string[] names = Enumerable.Empty<string>().Append("None").Union(childrenTypes.Select((t) => t.Name)).ToArray();
            int newIndex = EditorGUILayout.Popup(index, names);
            if (index != newIndex)
            {
                property.managedReferenceValue = newIndex > 0 ? System.Activator.CreateInstance(childrenTypes[newIndex - 1]) : null;
            }
        }

        public static void PropertyField(SerializedProperty property)
        {
            GUILayout.BeginHorizontal();
            GUILayout.Label(property.displayName, GUILayout.MinWidth(75));
            GUILayout.FlexibleSpace();
            EditorGUILayout.PropertyField(property, GUIContent.none, true, GUILayout.ExpandWidth(true), GUILayout.MaxWidth(100));
            GUILayout.EndHorizontal();
        }

        public static int Popup(string name, int index, string[] options)
        {
            GUILayout.BeginHorizontal();
            GUILayout.Label(name, GUILayout.MinWidth(75));
            GUILayout.FlexibleSpace();
            index = EditorGUILayout.Popup(index, options, GUILayout.ExpandWidth(true), GUILayout.MaxWidth(100));
            GUILayout.EndHorizontal();
            return index;
        }

        public static void ChildrenProperties(SerializedProperty property)
        {
            SerializedProperty copyProperty = property.Copy();
            if (!copyProperty.NextVisible(true))
            {
                return;
            }

            while (property.depth < copyProperty.depth)
            {
                EditorGUILayout.PropertyField(copyProperty, true);
                if (!copyProperty.NextVisible(false))
                {
                    break;
                }
            }
        }

        public static void BeginIndent()
        {
            EditorGUILayout.BeginHorizontal();
            GUILayout.Space(16);
            EditorGUILayout.BeginVertical();
        }

        public static void EndIndent()
        {
            EditorGUILayout.EndVertical();
            EditorGUILayout.EndHorizontal();
        }
    }
}
