﻿using UnityEngine;

namespace PK
{
    [System.Serializable]
    public class KeyValue<TKey, TValue>
    {
        [SerializeField] private TKey _key;
        [SerializeField] private TValue _value;

        public TKey Key { get { return _key; } }
        public TValue Value { get { return _value; } }

        public KeyValue()
        {
        }

        public KeyValue(TKey key, TValue value)
        {
            _key = key;
            _value = value;
        }
    }

    [System.Serializable]
    public class ReferenceKeyValue<TKey, TValue>
    {
        [SerializeReference] private TKey _key;
        [SerializeReference] private TValue _value;

        public TKey Key { get { return _key; } }
        public TValue Value { get { return _value; } }

        public ReferenceKeyValue()
        {
        }

        public ReferenceKeyValue(TKey key, TValue value)
        {
            _key = key;
            _value = value;
        }
    }
}
