﻿using UnityEngine;
using UnityEngine.Pool;

namespace PK
{
    public class SpriteRendererPool : MonoBehaviour
    {
        private static SpriteRendererPool _instance;

        private const int POOL_SIZE = 20;

        private IObjectPool<SpriteRenderer> _pool;

        private void Awake()
        {
            _pool = new ObjectPool<SpriteRenderer>(CreatePooledItem, OnTakeFromPool, OnReturnedToPool, OnDestroyPoolObject, true, POOL_SIZE);
        }

        public static SpriteRenderer Get()
        {
            if (_instance == null)
            {
                GameObject gameObject = new GameObject("SpriteRendererPool");
                _instance = gameObject.AddComponent<SpriteRendererPool>();
            }

            return _instance._pool.Get();
        }

        public static void Release(SpriteRenderer renderer)
        {
            renderer.transform.rotation = Quaternion.identity;
            _instance._pool.Release(renderer);
        }

        private SpriteRenderer CreatePooledItem()
        {
            GameObject gameObject = new GameObject();
            gameObject.transform.parent = transform;
            return gameObject.AddComponent<SpriteRenderer>();
        }

        private void OnTakeFromPool(SpriteRenderer renderer)
        {
            renderer.gameObject.SetActive(true);
        }

        private void OnReturnedToPool(SpriteRenderer renderer)
        {
            renderer.gameObject.SetActive(false);
        }

        private void OnDestroyPoolObject(SpriteRenderer renderer)
        {
            Destroy(renderer.gameObject);
        }
    }
}
