﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public class HexMapEditorToolsWindow : EditorWindow
    {
        private Vector2 _scrollPosition;

        [MenuItem("PK/Map Editor Tools")]
        public static void Open()
        {
            HexMapEditorToolsWindow window = (HexMapEditorToolsWindow)GetWindow(typeof(HexMapEditorToolsWindow), false, "Map Editor Tools");
            window.Show();
        }

        private void OnGUI()
        {
            if (HexMapEditorWindow.Instance == null)
            {
                return;
            }
            _scrollPosition = EditorGUILayout.BeginScrollView(_scrollPosition);
            EditorGUI.BeginChangeCheck();
            HexMapEditorWindow.Instance.OnToolsGUI();
            if (EditorGUI.EndChangeCheck())
            {
                HexMapEditorWindow.Instance.Repaint();
            }
            EditorGUILayout.EndScrollView();
            Repaint();
        }
    }
}
