﻿using UnityEditor;

namespace PK
{
    public static class ShadowGroupHelper
    {
        public static void DrawProperty(SerializedProperty property)
        {
            EditorGUI.BeginChangeCheck();
            property.intValue = EditorGUILayout.Popup(property.displayName, property.intValue, HexShadowGroups.Instance.ShadowGroupNames);
            if (EditorGUI.EndChangeCheck())
            {
                property.serializedObject.ApplyModifiedProperties();
            }
        }

        public static void DrawMaskProperty(SerializedProperty property)
        {
            EditorGUI.BeginChangeCheck();
            property.intValue = EditorGUILayout.MaskField(property.displayName, property.intValue, HexShadowGroups.Instance.ShadowGroupNames);
            if (EditorGUI.EndChangeCheck())
            {
                property.serializedObject.ApplyModifiedProperties();
            }
        }
    }
}
