﻿using UnityEditor;
using static PK.HexVariablesModel;

namespace PK
{
    public class GlobalVariablesTool : MapEditorTool
    {
        private HexMap _map;
        private SerializedObject _object;
        private SerializedProperty _property;

        public override void OnInspectorPanel()
        {
            if (_map != _view.Map)
            {
                if (_object != null)
                {
                    _object.Dispose();
                }
                _object = new SerializedObject(_view.Map);
                _map = _view.Map;
                _property = _object.FindProperty("_model").FindPropertyRelative("_globalVariables").FindPropertyRelative("_variables");
            }

            if (_property != null)
            {
                _object.UpdateIfRequiredOrScript();
                int size = _property.arraySize;
                EditorGUI.BeginChangeCheck();
                EditorGUILayout.PropertyField(_property);
                if (size < _property.arraySize)
                {
                    _property.GetArrayElementAtIndex(_property.arraySize - 1).boxedValue = new Variable(HexHelper.GenerateUID(), "Variable", VariableType.Bool);
                }
                if (EditorGUI.EndChangeCheck())
                {
                    _object.ApplyModifiedProperties();
                }
            }
        }
    }
}
