﻿using System.Collections.Generic;
using System.Linq;
using UnityEditor;
using UnityEngine;

namespace PK
{
    public abstract class MapPaintingTool : MapEditorTool
    {
        protected Vector2Int _hoveredTile;

        protected abstract Color PaintingToolGridColor { get; }

        protected abstract int BrushSize { get; set; }

        protected abstract int BrushDensity { get; set; }

        public abstract bool IsToolReady();

        public void PaintingToolInspectorPanel()
        {
            GUILayout.BeginHorizontal();
            GUILayout.Label("Brush size", EditorStyles.boldLabel);
            BrushSize = EditorGUILayout.IntSlider(BrushSize, 1, 10);
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("Brush density", EditorStyles.boldLabel);
            BrushDensity = EditorGUILayout.IntSlider(BrushDensity, 1, 100);
            GUILayout.EndHorizontal();
        }

        public override void OnMouseMove()
        {
            _hoveredTile = _view.GetHexPosition(GetMouseWorldPosition());
        }

        public override void OnDrawHandle()
        {
            if (IsToolReady() == false)
            {
                return;
            }
            DrawTileHandle(_hoveredTile, PaintingToolGridColor);
            List<Vector2Int> neighbours = HexHelper.GetNeighbourList(_hoveredTile, BrushSize - 1);
            foreach (Vector2Int neighbour in neighbours)
            {
                DrawTileHandle(neighbour, PaintingToolGridColor);
            }
        }

        public List<Vector2Int> GetPaintedHexes()
        {
            List<Vector2Int> result = HexHelper.GetNeighbourList(_hoveredTile, BrushSize - 1);
            result.Add(_hoveredTile);
            if (BrushDensity <= 99f)
            {
                int itemsToRemove = result.Count - Mathf.RoundToInt(result.Count * (BrushDensity / 100f));
                System.Random rnd = new System.Random();
                result = result
                    .OrderBy(x => rnd.Next())
                    .Skip(itemsToRemove)
                    .ToList();
            }
            return result;
        }

    }
}
