﻿using UnityEngine;

namespace PK
{
    public class PlaceObjectsTool : GenericPlacingTool<HexObject>
    {
        protected override HexObject[] Data => HexDatabase.Instance.Objects;

        protected override Texture2D GetIcon(HexObject instance)
        {
            return _editor.GetIcon(instance.AnySprite);
        }

        protected override void Place()
        {
            if (_view.CanPlaceObject(_hoveredTile))
            {
                RecordUndo();
                _view.PlaceObject(_hoveredTile, HexHelper.GetOffset(HexHelper.GetTilePosition(_hoveredTile), GetMouseWorldPosition()), _brushSelectedInstance);
            }
        }

        public override void OnDrawHandle()
        {
            if (_brushSelectedInstance != null)
            {
                DrawTileHandle(_hoveredTile);
                Vector3 position = GetMouseWorldPosition();
                DrawSpriteHandle(_brushSelectedInstance.AnySprite, _brushSelectedInstance.IsAligned ? HexHelper.GetTilePosition(HexHelper.GetHexPosition(position), _brushSelectedInstance.Offset) : position);
            }
        }
    }
}
