﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public class PlaceUtilitiesTool : MapEditorTool
    {
        private Vector2Int _hoveredTile;
        private EntityType _selectedType = EntityType.Unknown;

        public override void OnInspectorPanel()
        {
            DrawButton("Proximity Trigger", HexDatabase.Instance.ProximityTriggerIcon, EntityType.ProximityTrigger);
            DrawButton("Spawn Point", HexDatabase.Instance.SpawnPointIcon, EntityType.SpawnPoint);
            DrawButton("Map Zone", HexDatabase.Instance.MapZoneIcon, EntityType.MapZone);
        }

        public override void OnMouseMove()
        {
            _hoveredTile = _view.GetHexPosition(GetMouseWorldPosition());
        }

        public override void OnMouseClick()
        {
            if (Event.current.button != 0)
            {
                return;
            }

            Place();
            Event.current.Use();
        }

        private void DrawButton(string name, Sprite icon, EntityType type)
        {
            if (_selectedType == type)
            {
                EditorGUI.BeginDisabledGroup(true);
            }
            if (GUILayout.Button(new GUIContent(_editor.GetIcon(icon), name), GUILayout.Width(BUTTON_SIZE.x), GUILayout.Height(BUTTON_SIZE.y)))
            {
                _selectedType = type;
            }
            if (_selectedType == type)
            {
                EditorGUI.EndDisabledGroup();
            }
        }

        private void Place()
        {
            if (_selectedType == EntityType.Unknown)
            {
                return;
            }

            RecordUndo();
            if (_selectedType == EntityType.ProximityTrigger)
            {
                _view.PlaceProximityTrigger(_hoveredTile);
            }
            if (_selectedType == EntityType.SpawnPoint)
            {
                _view.PlaceSpawnPoint(_hoveredTile);
            }
            if (_selectedType == EntityType.MapZone)
            {
                _view.PlaceMapZone(_hoveredTile);
            }
        }

        public override void OnDrawHandle()
        {
            if (_selectedType == EntityType.ProximityTrigger)
            {
                DrawHandle(HexDatabase.Instance.ProximityTriggerIcon);
            }
            if (_selectedType == EntityType.SpawnPoint)
            {
                DrawHandle(HexDatabase.Instance.SpawnPointIcon);
            }
            if (_selectedType == EntityType.MapZone)
            {
                DrawHandle(HexDatabase.Instance.MapZoneIcon);
            }
        }

        private void DrawHandle(Sprite sprite)
        {
            DrawTileHandle(_hoveredTile);
            Vector3 position = GetMouseWorldPosition();
            DrawSpriteHandle(sprite, HexHelper.GetTilePosition(HexHelper.GetHexPosition(position)));
        }
    }
}
