﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public class RemoveRoadsTool : MapEditorTool
    {
        private Vector2Int _hoveredTile;

        public override void OnMouseMove()
        {
            _hoveredTile = _view.GetHexPosition(GetMouseWorldPosition());
        }

        public override void OnMouseDown()
        {
            if (Event.current.button == 0)
            {
                RecordUndo();
                _view.RemoveRoad(_hoveredTile);
                Event.current.Use();
            }
        }

        public override void OnDrawHandle()
        {
            DrawTileHandle(_hoveredTile, Color.red);
        }
    }
}
